const fs = require('fs');
const os = require('os');
const path = require('path');
const { spawn } = require('child_process');
const logger = require('./logger');

function resolveIconPath() {
  if (process.platform === 'win32') {
    const packagedIcon = path.join(process.resourcesPath, 'icon.ico');
    if (fs.existsSync(packagedIcon)) {
      return packagedIcon;
    }
    const buildIcon = path.join(__dirname, '..', '..', 'build', 'icon.ico');
    if (fs.existsSync(buildIcon)) {
      return buildIcon;
    }
    return path.join(__dirname, '..', '..', 'assets', 'app-icon.ico');
  }

  if (process.platform === 'darwin') {
    const packagedIcns = path.join(process.resourcesPath, 'icon.icns');
    if (fs.existsSync(packagedIcns)) {
      return packagedIcns;
    }
    const buildIcns = path.join(__dirname, '..', '..', 'build', 'icon.icns');
    if (fs.existsSync(buildIcns)) {
      return buildIcns;
    }
    const assetsIcns = path.join(__dirname, '..', '..', 'assets', 'app-icon.icns');
    if (fs.existsSync(assetsIcns)) {
      return assetsIcns;
    }
  }

  const packagedPng = path.join(process.resourcesPath, 'icon.png');
  if (fs.existsSync(packagedPng)) {
    return packagedPng;
  }
  const buildPng = path.join(__dirname, '..', '..', 'build', 'icon.png');
  if (fs.existsSync(buildPng)) {
    return buildPng;
  }
  return path.join(__dirname, '..', '..', 'assets', 'app-icon.png');
}

function updateWindowsShortcutIcons(targetIconPath) {
  if (process.platform !== 'win32') {
    return;
  }

  try {
    if (!fs.existsSync(targetIconPath)) {
      return;
    }

    const sanitizedIconPath = targetIconPath.replace(/'/g, "''");
    const scriptContent = `
$shortcuts = @(
  Join-Path $env:APPDATA 'Microsoft\\Windows\\Start Menu\\Programs\\MiBa Video Manager.lnk'),
  Join-Path $env:APPDATA 'Microsoft\\Windows\\Start Menu\\Programs\\MiBa Video Manager\\MiBa Video Manager.lnk'
)
$desiredIcon = '${sanitizedIconPath},0'
foreach ($shortcutPath in $shortcuts) {
  if (Test-Path $shortcutPath) {
    $shell = New-Object -ComObject WScript.Shell
    $shortcut = $shell.CreateShortcut($shortcutPath)
    if ($shortcut.IconLocation -ne $desiredIcon) {
      $shortcut.IconLocation = $desiredIcon
      $shortcut.Save()
    }
  }
}
try { ie4uinit.exe -show } catch {}
`;

    const tempScriptPath = path.join(os.tmpdir(), 'miba-update-shortcut.ps1');
    fs.writeFileSync(tempScriptPath, scriptContent, 'utf8');
    const child = spawn('powershell.exe', ['-NoProfile', '-ExecutionPolicy', 'Bypass', '-File', tempScriptPath], {
      windowsHide: true,
      stdio: 'ignore'
    });
    child.on('error', (error) => {
      logger.warn('Failed to trigger shortcut icon refresh:', error.message || error);
    });
  } catch (error) {
    logger.warn('Failed to update Windows shortcuts icon:', error.message || error);
  }
}

module.exports = {
  resolveIconPath,
  updateWindowsShortcutIcons
};

